using System;
using System.Net;

namespace gov.va.med.VBECS.VistaLinkServer.Core
{
	/// <summary>
	/// This class represents caller (remote client) security information
	/// needed to perform published procedure access authorization
	/// on a server side. 
	/// </summary>
	public class CallerSecurityEvidence
	{
		private readonly string _securityContext;
		private readonly IPAddress _clientIp;

		/// <summary>
		/// Constructor specifying all parameters needed to perform authorization. 
		/// </summary>
		/// <param name="securityContext">Security context provided by caller.</param>
		/// <param name="clientIp">Caller IP address.</param>
		public CallerSecurityEvidence( string securityContext, IPAddress clientIp )
		{
			if( securityContext == null )
				throw( new ArgumentNullException( "securityContext" ) );

			if( clientIp == null )
				throw( new ArgumentNullException( "clientIp" ) );

			_securityContext = securityContext;
			_clientIp = clientIp;
		}

		/// <summary>
		/// Security context provided by caller.
		/// </summary>
		public string SecurityContext
		{
			get
			{
				return _securityContext;
			}
		}

		/// <summary>
		/// Client IP address.
		/// </summary>
		public IPAddress ClientIp
		{
			get
			{
				return _clientIp;
			}
		}
	}
}
